{*******************************************************************************
 *                               Liste Version 3.0                             *
 *                (c) 2003 Klaus Dingemann und Ulrich Borghoff                 *
 *                           eMail: sum-delphi@web.de                          *
 * *****************************************************************************
 * Beachten Sie bitte, dass es sich hier um ein vllig neues Modul handelt,    *
 * die nicht zur Version vom Oktober 2002 kompatibel ist.                      *
 *                                                                             *
 * Bitte ndern Sie diese Datei nicht ab, sondern teilen den Entwicklern Ihre  *
 * Verbesserungsvorschlge oder Fehler (und ggf. deren Berichtigung) mit.      *
 *                                                                             *
 * Fr den Unterricht sollten Sie nur die mListe.dcu Datei verwenden. Diese    *
 * muss sich im Ordner ..delphi/lib befinden. Die Angabe "uses mListe" ist     *
 * dann schon ausreichend.                                                     *
 *                                                                             *
 * Danke fr Ihre Mitarbeit.                                                   *
 *******************************************************************************}


unit mListe;

interface

type
  Knoten=class(TObject)
  private
    kenntInhalt:TObject;
    kenntNachfolger, kenntVorgaenger:Knoten;
  public
    constructor init(pInhalt:TObject;pVorgaenger, pNachfolger:Knoten);
    procedure setzeInhalt(pInhalt:TObject);
    function inhalt:TObject;
    procedure setzeVorgaenger(pVorgaenger:Knoten);
    function vorgaenger:Knoten;
    procedure setzeNachfolger(pNachfolger:Knoten);
    function nachfolger:Knoten;
    destructor gibFrei;
  end;

  Liste=class(TObject)
  private
    hatBug, hatHeck, kenntAktuelles:Knoten;
    zLaenge:integer;
  public
  constructor init;virtual;
  function istLeer:boolean;virtual;
  function istAmAnfang:boolean; virtual;
  function istAmEnde:boolean;virtual;
  function istDavor:boolean;virtual;
  function istDahinter:boolean;virtual;
  procedure vor;virtual;
  procedure zurueck;virtual;
  procedure zumAnfang;virtual;
  procedure zumEnde;virtual;
  function aktuelles:tObject; virtual;
  procedure ersetzeAktuelles(pInhalt:TObject);virtual;
  procedure fuegeDavorEin(pInhalt:TObject);virtual;
  procedure fuegeDahinterEin(pInhalt:TObject);virtual;
  procedure setzeDavor(pInhalt:TObject);virtual;
  procedure haengeAn(pInhalt:TObject);virtual;
  procedure entferneAktuelles;virtual;
  function laenge:integer;virtual;
  procedure verketteKnoten(pLinksknoten, pRechtsknoten:Knoten);virtual;
  procedure haengeListeAn(pListe:Liste);virtual;
  destructor gibFrei;virtual;
 end;


implementation

  constructor Knoten.init(pInhalt:TObject;pVorgaenger, pNachfolger:Knoten);
  begin
    kenntInhalt:=pInhalt;
    kenntNachfolger:=pNachfolger;
    kenntVorgaenger:=pVorgaenger;
  end;

  function Knoten.inhalt:TObject;
  begin
    result:=kenntInhalt;
  end;

  function Knoten.nachfolger:Knoten;
  begin
    result:=kenntNachfolger;
  end;

  function Knoten.vorgaenger:Knoten;
  begin
    result:=kenntVorgaenger;
  end;

  procedure Knoten.setzeInhalt(pInhalt:TObject);
  begin
    kenntInhalt:=pInhalt;
  end;

  procedure Knoten.setzeNachfolger(pNachfolger:Knoten);
  begin
    kenntNachfolger:=pNachfolger;
  end;

  procedure Knoten.setzeVorgaenger(pVorgaenger:Knoten);
  begin
    kenntVorgaenger:=pVorgaenger;
  end;


  destructor Knoten.gibFrei;
  begin
  end;

  constructor Liste.init;
  begin
    hatBug:=Knoten.init(nil,nil,nil);
    hatHeck:=Knoten.init(nil,hatBug,nil);
    kenntAktuelles:=hatBug;
    hatBug.setzeNachfolger(hatHeck);
    zLaenge:=0;
  end;

  function Liste.istLeer:boolean;
  begin
    result:=hatBug.nachfolger=hatHeck;
  end;

  function Liste.istAmAnfang:boolean;
  begin
    result:=not self.istLeer and (kenntAktuelles.vorgaenger=hatBug);
  end;

  function Liste.istAmEnde:boolean;
  begin
    result:=not self.istLeer and (kenntAktuelles.nachfolger=hatHeck);
  end;

  function Liste.istDavor:boolean;
  begin
    result:=(kenntAktuelles=hatBug);
  end;

  function Liste.istDahinter:boolean;
  begin
    result:=(kenntAktuelles=hatHeck);
  end;

  procedure Liste.vor;
  begin
    if not self.istDahinter then
      kenntAktuelles:=kenntAktuelles.nachfolger
  end;

  procedure Liste.zurueck;
  begin
    if not istDavor then
      kenntAktuelles:=kenntAktuelles.vorgaenger
  end;

  procedure Liste.zumAnfang;
  begin
    kenntAktuelles:=hatBug.nachfolger;
  end;

  procedure Liste.zumEnde;
  begin
    kenntAktuelles:=hatHeck.vorgaenger;
  end;

  function Liste.aktuelles:tObject;
  begin
    result:=kenntAktuelles.inhalt;
  end;

  procedure Liste.ersetzeAktuelles(pInhalt:TObject);
  begin
    if not (istDavor or istDahinter) then
      kenntAktuelles.setzeInhalt(pInhalt)
  end;

  procedure Liste.fuegeDavorEin(pInhalt:TObject);
   var
    lNeuKnoten:Knoten;
  begin
    if self.istDavor then
      vor;
    lNeuknoten:=Knoten.init(pInhalt,kenntAktuelles.vorgaenger,kenntAktuelles);
    kenntAktuelles.vorgaenger.setzeNachfolger(lNeuknoten);
    kenntAktuelles.setzeVorgaenger(lNeuknoten);
    inc(zLaenge);
  end;

  procedure Liste.fuegeDahinterEin(pInhalt:TObject);
  var
    lNeuKnoten:Knoten;
  begin
    if self.istDavor then
      zurueck;
    lNeuknoten:=Knoten.init(pInhalt,kenntAktuelles,kenntAktuelles.nachfolger);
    kenntAktuelles.nachfolger.setzeVorgaenger(lNeuknoten);
    kenntAktuelles.setzeNachfolger(lNeuknoten);
    inc(zLaenge);
  end;

  procedure Liste.setzeDavor(pInhalt:TObject);
  var
    lNeuknoten:Knoten;
  begin
    lNeuknoten:=Knoten.init(pInhalt,hatBug,hatBug.nachfolger);
    hatBug.setzeNachfolger(lNeuknoten);
    inc(zLaenge);
  end;

  procedure Liste.haengeAn(pInhalt:TObject);
  var
    lNeuknoten:Knoten;
  begin
    lNeuknoten:=Knoten.init(pInhalt,hatHeck.vorgaenger,hatHeck);
    hatHeck.vorgaenger.setzeNachfolger(lNeuknoten);
    hatHeck.setzeVorgaenger(lNeuknoten);
    inc(zLaenge);
  end;


  procedure Liste.entferneAktuelles;
  begin
    if not (istDavor or istDahinter) then begin
       self.verketteKnoten(kenntAktuelles.vorgaenger,kenntAktuelles.nachfolger);
       kenntAktuelles:=kenntAktuelles.nachfolger;
       dec(zLaenge);
    end;
  end;

  function Liste.laenge:integer;
  begin
    result:=zLaenge;
  end;

  procedure Liste.verketteKnoten(pLinksknoten, pRechtsknoten:Knoten);
  begin
    pLinksknoten.setzeNachfolger(pRechtsknoten);
    pRechtsknoten.setzeVorgaenger(pLinksknoten);
  end;

  procedure Liste.haengeListeAn(pListe:Liste);
  begin
    if not pListe.istLeer then begin
      zLaenge:=zLaenge+pListe.laenge;
      verketteKnoten(hatHeck.vorgaenger,pListe.hatBug.nachfolger);
      verketteKnoten(pListe.hatHeck.vorgaenger,hatHeck);
      verketteKnoten(pListe.hatBug,pListe.hatHeck);
    end;
  end;

  destructor Liste.gibFrei;
  begin
     hatBug.gibFrei;
     hatHeck.gibFrei;
  end;


end.
